import discord

from discord.ext import commands

import json

with open("config.json", "r") as f:

    config = json.load(f)

DEPART_CHANNEL_ID = config["DEPART_CHANNEL_ID"]

class Depart(commands.Cog):

    def __init__(self, bot):

        self.bot = bot

    @commands.Cog.listener()

    async def on_member_remove(self, member):

        channel = member.guild.get_channel(DEPART_CHANNEL_ID)

        if channel:

            embed = discord.Embed(

                title="👋 Au revoir !",

                description=f"{member} a quitté le serveur. Nous lui souhaitons bonne continuation.",

                color=discord.Color.red()

            )

            await channel.send(embed=embed)

async def setup(bot):

    await bot.add_cog(Depart(bot))